/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public long count();

    public long count(Bson var1);

    public long count(Bson var1, CountOptions var2);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public FindIterable<TDocument> find();

    public <TResult> FindIterable<TResult> find(Class<TResult> var1);

    public FindIterable<TDocument> find(Bson var1);

    public <TResult> FindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public MapReduceIterable<TDocument> mapReduce(String var1, String var2);

    public <TResult> MapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2);

    public void insertOne(TDocument var1);

    public void insertOne(TDocument var1, InsertOneOptions var2);

    public void insertMany(List<? extends TDocument> var1);

    public void insertMany(List<? extends TDocument> var1, InsertManyOptions var2);

    public DeleteResult deleteOne(Bson var1);

    public DeleteResult deleteOne(Bson var1, DeleteOptions var2);

    public DeleteResult deleteMany(Bson var1);

    public DeleteResult deleteMany(Bson var1, DeleteOptions var2);

    public UpdateResult replaceOne(Bson var1, TDocument var2);

    public UpdateResult replaceOne(Bson var1, TDocument var2, UpdateOptions var3);

    public UpdateResult updateOne(Bson var1, Bson var2);

    public UpdateResult updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public UpdateResult updateMany(Bson var1, Bson var2);

    public UpdateResult updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public TDocument findOneAndDelete(Bson var1);

    public TDocument findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    public TDocument findOneAndReplace(Bson var1, TDocument var2);

    public TDocument findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3);

    public TDocument findOneAndUpdate(Bson var1, Bson var2);

    public TDocument findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    public void drop();

    public String createIndex(Bson var1);

    public String createIndex(Bson var1, IndexOptions var2);

    public List<String> createIndexes(List<IndexModel> var1);

    public ListIndexesIterable<Document> listIndexes();

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public void dropIndex(String var1);

    public void dropIndex(Bson var1);

    public void dropIndexes();

    public void renameCollection(MongoNamespace var1);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2);
}

